﻿'   PSW Series GP-IB Sample Program for Vb2008 or Higher

'   Please Open project (PSW_Access.vbproj), Not Open Solution
'   Remove Rerences for NationalInstrument common and NI488.2
'   Add References NationalInstrument common and NI488.2 on Your PC

'   ソリューションファイルでなくプロジェクトファイル(PSW_Access.vbproj)を開いてください。
'   ナショナルインスツルメンツのライブラリの参照がおかしい場合は参照をやり直してください。

Imports System
Imports System.Drawing
Imports System.Collections
Imports System.ComponentModel
Imports System.Windows.Forms
Imports NationalInstruments.NI4882

Public Class mainForm
    Private device As Device
    Private Opened As Integer

    ' OPNE/CLOSE
    Private Sub btnOpen_Close_Click(sender As Object, e As EventArgs) Handles btnOpen_Close.Click
        Dim BourdId As Integer
        Opened = 1
        If (btnOpen_Close.Text = "OPEN") Then
            Try
                Cursor.Current = Cursors.WaitCursor
                ' Device Open and Init
                device = New Device(BourdId, CByte(cmbAddress.SelectedIndex + 1))
                device.Write("*cls" + vbLf)
                device.Write("ALLOUTOFF" + vbLf)
                btnLoad.Text = "OUT ON"

                ' Set form
                btnOpen_Close.Text = "CLOSE"
                btnLoad.Enabled = True
                btnMonitor.Enabled = True
                btnValueSet.Enabled = True
                btnVoltSet.Enabled = True
                cmbAddress.Enabled = False

            Catch ex As Exception
                MessageBox.Show(ex.Message)
            Finally
                Cursor.Current = Cursors.Default
            End Try
        Else
            Try
                'Device Close
                device.Write("ALLOUTOFF" + vbLf)
                device.Write("LOCAL" + vbLf)
                device.Dispose()

                'Set form
                btnOpen_Close.Text = "OPEN"
                btnLoad.Enabled = False
                btnMonitor.Enabled = False
                btnValueSet.Enabled = False
                btnVoltSet.Enabled = False
                cmbAddress.Enabled = True

            Catch ex As Exception
                MessageBox.Show(ex.Message)
            End Try
        End If
    End Sub

    'Form Close(x Button)
    Private Sub mainForm_FormClosing(sender As Object, e As FormClosingEventArgs) Handles Me.FormClosing
        'Device Close
        If (cmbAddress.Enabled = False) Then
            device.Write("ALLOUTOFF" + vbLf)
            device.Write("LOCAL" + vbLf)

        End If
        If (Opened <> 0) Then
            device.Dispose()
        End If
    End Sub

    'OUT ON/OFF
    Private Sub btnLoad_Click(sender As Object, e As EventArgs) Handles btnLoad.Click
        If (btnLoad.Text = "OUT ON") Then
            ' OFF -> ON
            device.Write(":OUTP1 1" + vbLf)
            btnLoad.Text = "OUT OFF"
        Else
            ' ON -> OFF
            device.Write(":OUTP1 0" + vbLf)
            btnLoad.Text = "OUT ON"
        End If
    End Sub

    ' Set Button
    Private Sub btnValueSet_Click(sender As Object, e As EventArgs) Handles btnValueSet.Click
        Dim SendMsg As String

        SendMsg = "ISET1:" + txtValue.Text + vbLf
        Try
            device.Write(SendMsg)
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try

    End Sub

    Private Sub btnVoltSet_Click(sender As Object, e As EventArgs) Handles btnVoltSet.Click
        Dim SendMsg As String

        SendMsg = "VSET1:" + txtVoltage.Text + vbLf
        Try
            device.Write(SendMsg)
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub

    ' Monitor
    Private Sub btnMonitor_Click(sender As Object, e As EventArgs) Handles btnMonitor.Click
        Dim txtCurrent, txtPower, txtVoltage As String
        Try
            Cursor.Current = Cursors.WaitCursor

            device.Write(":MEAS1:all?" + vbLf)
            txtMeasure.Text = device.ReadString()
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        Finally
            Cursor.Current = Cursors.Default
        End Try
    End Sub

    'Load
    Private Sub mainForm_Load(sender As Object, e As EventArgs) Handles Me.Load
        Dim i As Integer
        Opened = 0
        For i = 1 To 29
            cmbAddress.Items.Add(i)
        Next i
        cmbAddress.SelectedIndex = 0

        ' Set form
        btnOpen_Close.Text = "OPEN"
        btnLoad.Enabled = False
        btnMonitor.Enabled = False
        btnValueSet.Enabled = False
        btnVoltSet.Enabled = False
        cmbAddress.Enabled = True
    End Sub

End Class
