﻿'   PSW Series Serial Sample Program　for Vb2008 or Higher
'   Please Open project (PSW_Access.vbproj), Not Open Solution

'   ソリューションファイルでなくプロジェクトファイル(PSW_Access.vbproj)を開いてください。

Imports System
Imports System.Drawing
Imports System.Collections
Imports System.ComponentModel
Imports System.Windows.Forms


Public Class mainForm

    Private Opened As Integer

    ' OPNE/CLOSE
    Private Sub btnOpen_Close_Click(sender As Object, e As EventArgs) Handles btnOpen_Close.Click

        Opened = 1
        If (btnOpen_Close.Text = "OPEN") Then
            Try
                Cursor.Current = Cursors.WaitCursor
                ' Device Open and Init
                SerialPort1.PortName = "COM" + (cmbAddress.SelectedIndex + 1).ToString()
                SerialPort1.BaudRate = 115200
                SerialPort1.DataBits = 8
                SerialPort1.StopBits = System.IO.Ports.StopBits.One
                SerialPort1.Parity = System.IO.Ports.Parity.None
                SerialPort1.Handshake = System.IO.Ports.Handshake.None
                SerialPort1.Open()
                SerialPort1.DiscardInBuffer()
                SerialPort1.WriteLine("*cls" + vbLf)
                SerialPort1.WriteLine("ALLOUTOFF" + vbLf)
                lblUnit.Text = "A"
                btnLoad.Text = "OUT ON"

                ' Set form
                btnOpen_Close.Text = "CLOSE"
                btnLoad.Enabled = True
                btnMonitor.Enabled = True
                btnValueSet.Enabled = True
                btnVoltSet.Enabled = True
                cmbAddress.Enabled = False


            Catch ex As Exception
                MessageBox.Show(ex.Message)
            Finally
                Cursor.Current = Cursors.Default
            End Try
        Else
            Try
                'Device Close
                SerialPort1.WriteLine("ALLOUTOFF" + vbLf)
                SerialPort1.WriteLine("LOCAL" + vbLf)
                System.Threading.Thread.Sleep(200)
                SerialPort1.Close()

                'Set form
                btnOpen_Close.Text = "OPEN"
                btnLoad.Enabled = False
                btnMonitor.Enabled = False
                btnValueSet.Enabled = False
                btnVoltSet.Enabled = False
                cmbAddress.Enabled = True

            Catch ex As Exception
                MessageBox.Show(ex.Message)
            End Try
        End If
    End Sub

    'Form Close(x Button)
    Private Sub mainForm_FormClosing(sender As Object, e As FormClosingEventArgs) Handles Me.FormClosing
        'Device Close
        If (cmbAddress.Enabled = False) Then
            SerialPort1.WriteLine("ALLOUTOFF" + vbLf)
            SerialPort1.WriteLine("LOCAL" + vbLf)
            System.Threading.Thread.Sleep(200)
        End If
        If (Opened <> 0) Then
            SerialPort1.Close()
        End If
    End Sub


    'Load ON/OFF
    Private Sub btnLoad_Click(sender As Object, e As EventArgs) Handles btnLoad.Click
        If (btnLoad.Text = "OUT ON") Then
            ' OFF -> ON
            SerialPort1.WriteLine(":OUTP1 1" + vbLf)
            btnLoad.Text = "OUT OFF"
        Else
            ' ON -> OFF
            SerialPort1.WriteLine(":OUTP1 0" + vbLf)
            btnLoad.Text = "OUT ON"
        End If
    End Sub

    ' Set Button
    Private Sub btnValueSet_Click(sender As Object, e As EventArgs) Handles btnValueSet.Click
        Dim SendMsg As String

        SendMsg = "ISET1:" + txtValue.Text + vbLf
        Try
            SerialPort1.WriteLine(SendMsg)
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try

    End Sub

    Private Sub btnVoltSet_Click(sender As Object, e As EventArgs) Handles btnVoltSet.Click
        Dim SendMsg As String

        SendMsg = "VSET1:" + txtVoltage.Text + vbLf
        Try
            SerialPort1.WriteLine(SendMsg)
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub

    ' Monitor
    Private Sub btnMonitor_Click(sender As Object, e As EventArgs) Handles btnMonitor.Click
        Dim txtCurrent, txtPower, txtVoltage As String
        Try
            Cursor.Current = Cursors.WaitCursor

            SerialPort1.WriteLine(":MEAS1:all?" + vbLf)
            System.Threading.Thread.Sleep(100)
            txtMeasure.Text = SerialPort1.ReadExisting()

        Catch ex As Exception
            MessageBox.Show(ex.Message)
        Finally
            Cursor.Current = Cursors.Default
        End Try
    End Sub

    'Load
    Private Sub mainForm_Load(sender As Object, e As EventArgs) Handles Me.Load
        Dim i As Integer
        Opened = 0
        For i = 1 To 29
            cmbAddress.Items.Add(i)
        Next i
        cmbAddress.SelectedIndex = 0

        ' Set form
        btnOpen_Close.Text = "OPEN"
        btnLoad.Enabled = False
        btnMonitor.Enabled = False
        btnValueSet.Enabled = False
        btnVoltSet.Enabled = False
        cmbAddress.Enabled = True
    End Sub


End Class
