﻿'   GPP Series Socket Sample Program　for Vb2008 or Higher
'   Please Open project (GPP_Access.vbproj), Not Open Solution
'   ソリューションファイルでなくプロジェクトファイル(_Access.vbproj)を開いてください。

Imports System
Imports System.Drawing
Imports System.Collections
Imports System.ComponentModel
Imports System.Windows.Forms

Public Class mainForm

    Private Opened As Integer
    Private m_TcpClient As System.Net.Sockets.TcpClient
    Private m_NetworkStream As System.Net.Sockets.NetworkStream

    ' OPNE/CLOSE
    Private Sub btnOpen_Close_Click(sender As Object, e As EventArgs) Handles btnOpen_Close.Click

        Opened = 1
        If (btnOpen_Close.Text = "OPEN") Then
            Try
                Cursor.Current = Cursors.WaitCursor
                ' Device Open and Init
                m_TcpClient = New System.Net.Sockets.TcpClient
                m_TcpClient.Connect(txtIPAddress.Text, 1026)
                m_NetworkStream = m_TcpClient.GetStream

                ' Set form
                btnLoad.Text = "OUT ON"
                btnOpen_Close.Text = "CLOSE"
                btnLoad.Enabled = True
                btnMonitor.Enabled = True
                btnValueSet.Enabled = True
                btnVoltSet.Enabled = True
                txtIPAddress.Enabled = False

                WriteLine("*cls" + vbLf)
                WriteLine("ALLOUTOFF" + vbLf)           ' Require 500ms Wait
                System.Threading.Thread.Sleep(500)
                WriteLine("*idn?" + vbLf)
                System.Threading.Thread.Sleep(100)
                txtMeasure.Text = Readbuff()

            Catch ex As Exception
                MessageBox.Show(ex.Message)
            Finally
                Cursor.Current = Cursors.Default
            End Try
        Else
            Try
                'Device Close
                WriteLine("ALLOUTOFF" + vbLf)
                WriteLine("LOCAL" + vbLf)

                System.Threading.Thread.Sleep(200)

                If ((m_TcpClient IsNot Nothing) AndAlso (m_TcpClient.Connected = True)) Then
                    m_NetworkStream.Close()
                    m_TcpClient.Close()
                End If
                m_NetworkStream = Nothing
                m_TcpClient = Nothing

                'Set form
                btnOpen_Close.Text = "OPEN"
                btnLoad.Enabled = False
                btnMonitor.Enabled = False
                btnValueSet.Enabled = False
                btnVoltSet.Enabled = False
                txtIPAddress.Enabled = True

            Catch ex As Exception
                MessageBox.Show(ex.Message)
            End Try
        End If
    End Sub

    'Form Close(x Button)
    Private Sub mainForm_FormClosing(sender As Object, e As FormClosingEventArgs) Handles Me.FormClosing
        'Device Close
        If (txtIPAddress.Enabled = False) Then
            WriteLine("ALLOUTOFF" + vbLf)
            WriteLine("LOCAL" + vbLf)

            System.Threading.Thread.Sleep(200)
        End If
        If (Opened <> 0) Then
            If ((m_TcpClient IsNot Nothing) AndAlso (m_TcpClient.Connected = True)) Then
                m_NetworkStream.Close()
                m_TcpClient.Close()
            End If
            m_NetworkStream = Nothing
            m_TcpClient = Nothing
        End If
    End Sub

    'Load ON/OFF
    Private Sub btnLoad_Click(sender As Object, e As EventArgs) Handles btnLoad.Click
        If (btnLoad.Text = "OUT ON") Then
            ' OFF -> ON
            WriteLine(":OUTP1 1" + vbLf)
            btnLoad.Text = "OUT OFF"
        Else
            ' ON -> OFF
            WriteLine(":OUTP1 0" + vbLf)
            btnLoad.Text = "OUT ON"
        End If
    End Sub

    ' Set Button
    Private Sub btnValueSet_Click(sender As Object, e As EventArgs) Handles btnValueSet.Click
        Dim SendMsg As String

        SendMsg = "ISET1:" + txtValue.Text + vbLf
        Try
            WriteLine(SendMsg)
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try

    End Sub

    ' Set Button
    Private Sub btnVoltSet_Click(sender As Object, e As EventArgs) Handles btnVoltSet.Click
        Dim SendMsg As String

        SendMsg = "VSET1:" + txtVoltage.Text + vbLf
        Try
            WriteLine(SendMsg)
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub

    ' Monitor
    Private Sub btnMonitor_Click(sender As Object, e As EventArgs) Handles btnMonitor.Click

        Try
            Cursor.Current = Cursors.WaitCursor
            WriteLine(":MEAS1:all?" + vbLf)
            System.Threading.Thread.Sleep(100)
            txtMeasure.Text = Readbuff()
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        Finally
            Cursor.Current = Cursors.Default
        End Try
    End Sub

    'Load
    Private Sub mainForm_Load(sender As Object, e As EventArgs) Handles Me.Load
        Opened = 0

        ' Set form
        btnOpen_Close.Text = "OPEN"
        btnLoad.Enabled = False
        btnMonitor.Enabled = False
        btnValueSet.Enabled = False
        btnVoltSet.Enabled = False
        txtIPAddress.Enabled = True
    End Sub

    'Wirte Message by socket
    Private Sub WriteLine(sendMsg As String)
        Dim SendBuff() As Byte = System.Text.Encoding.GetEncoding("SHIFT-JIS").GetBytes(sendMsg)

        m_NetworkStream.Write(SendBuff, 0, SendBuff.Length)
        m_NetworkStream.Flush()

    End Sub

    'read Message by socket
    Private Function Readbuff() As String
        Dim reciveBuff As Byte() = New Byte(256) {}
        Dim DataCnt As Integer = m_TcpClient.Available

        If (DataCnt > 255) Then DataCnt = 255
        m_NetworkStream.Read(reciveBuff, 0, DataCnt)
        Readbuff = System.Text.Encoding.GetEncoding("SHIFT-JIS").GetString(reciveBuff).Substring(0, DataCnt)

    End Function

End Class
