﻿//   PSW Series GP-IB Sample Program for VC# 2008 or Higher

//   Please Open project (PSW_Access.csproj), Not Open Solution
//   Remove Rerences for NationalInstrument common and NI488.2
//   Add References NationalInstrument common and NI488.2 on Your PC

//   ソリューションファイルでなくプロジェクトファイル(PSW_Access.csproj)を開いてください。
//   ナショナルインスツルメンツのライブラリの参照がおかしい場合は参照をやり直してください。


using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using NationalInstruments.NI4882;

namespace PSW_Access
{
    public partial class PSW_Access : Form
    {
        private Device device;
        private int Opened;

        // Open Window
        public PSW_Access()
        {
            InitializeComponent();

            Opened = 0;
            for (int i = 1; i < 30; i++)
                cmbAddress.Items.Add(i);
            cmbAddress.SelectedIndex = 0;

            // Set form
            btnOpen_Close.Text = "OPEN";
            btnLoad.Enabled = false;
            btnMonitor.Enabled = false;
            btnValueSet.Enabled = false; 
            btnVoltage.Enabled = false;
            cmbAddress.Enabled = true;
        }

        // Form Close(x Button)
        private void Form1_FormClosing(object sender,FormClosingEventArgs e)
        {
            // Device Close
            if(cmbAddress.Enabled == false)
                device.Write("ALLOUTOFF\n");
                device.Write("LOCAL\n");

            if( Opened != 0)
                device.Dispose();

        }
        // Open/Close Button
        private void btnOpen_Close_Click(object sender, EventArgs e)
        {
            if(btnOpen_Close.Text == "OPEN"){
                try
                {
                    int BourdId = 0 ;
                    Opened = 1;
                    Cursor.Current = Cursors.WaitCursor;
                    // Device Open and Init
                    device = new Device(BourdId, (byte)(cmbAddress.SelectedIndex + 1));
                    device.Write("*cls\n");
                    device.Write("ALLOUTOFF\n");
                    btnLoad.Text = "OUT ON";

                    // Set form
                    btnOpen_Close.Text = "CLOSE";
                    btnLoad.Enabled = true;

                    btnMonitor.Enabled = true;
                    btnValueSet.Enabled = true;
                    btnVoltage.Enabled = true;
                    cmbAddress.Enabled = false;

                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.Message);
                }
                finally
                {
                    Cursor.Current = Cursors.Default;
                }
            }
            else{
                try
                {
                    // Device Close
                    device.Write("ALLOUTOFF\n");
                    device.Write("LOCAL\n");
                    device.Dispose();

                    // Set form
                    btnOpen_Close.Text = "OPEN";
                    btnLoad.Enabled = false ;

                    btnMonitor.Enabled = false ;
                    btnValueSet.Enabled = false;
                    btnVoltage.Enabled = false;
                    cmbAddress.Enabled = true;
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.Message);
                }
            }

        }

        // Load Button
        private void btnLoad_Click(object sender, EventArgs e)
        {
            if (btnLoad.Text == "OUT ON")
            {
                // OFF -> ON
                device.Write(":OUTP1 1\n");
                btnLoad.Text = "OUT OFF";
            }
            else
            {
                // ON -> OFF
                device.Write(":OUTP1 0\n");
                btnLoad.Text = "OUT ON";
            }
        }

        // Set Button
        private void btnValueSet_Click(object sender, EventArgs e)
        {
            string SendMsg = "";
 
            SendMsg = "ISET1:" + ReplaceCommonEscapeSequences(txtValue.Text);
            try
            {
                device.Write(SendMsg);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
         }
        private void btnVoltage_Click(object sender, EventArgs e)
        {
            string SendMsg = "";

            SendMsg = "VSET1:" + ReplaceCommonEscapeSequences(txtVoltage.Text);
            try
            {
                device.Write(SendMsg);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }
        // Monitor Button
        private void btnMonitor_Click(object sender, EventArgs e)
        {

            try
            {
                Cursor.Current = Cursors.WaitCursor;

                device.Write(":MEAS1:ALL?\n");
                txtMeasure.Text = device.ReadString();

            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
            finally
            {
                Cursor.Current = Cursors.Default;
            }
        }

        private string ReplaceCommonEscapeSequences(string s)
        {
            return s.Replace("\\n", "\n").Replace("\\r", "\r");
        }

        private string InsertCommonEscapeSequences(string s)
        {
            return s.Replace("\n", "\\n").Replace("\r", "\\r");
        }


    }
}
