﻿//   GPP Series Serial Sample Program for VC# 2008 or Higher
//   Please Open project (GPP_Access.csproj), Not Open Solution
//   ソリューションファイルでなくプロジェクトファイル(GPP_Access.csproj)を開いてください。

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace GPP_Access
{
    public partial class GPP_Access : Form
 
    {
        private int Opened;
        private System.Net.Sockets.TcpClient m_TcpClient;           // TCPクライアント
        private System.Net.Sockets.NetworkStream m_NetworkStream;   // ネットワークストリーム

        // Open Window
        public GPP_Access()
        {
            InitializeComponent();

            Opened = 0;

            // Set form
            btnOpen_Close.Text = "OPEN";
            btnLoad.Enabled = false;
            btnMonitor.Enabled = false;
            btnValueSet.Enabled = false;
            btnVoltSet.Enabled = false;
            txtIPAddress.Enabled = true;
        }

        // Form Close(x Button)
        private void Form1_FormClosing(object sender,FormClosingEventArgs e)
        {
            // Device Close
            if (txtIPAddress.Enabled == false)
            {
                WriteLine("ALLOUTOFF\n");
                WriteLine("LOCAL\n");
                System.Threading.Thread.Sleep(200);
            }
            if (Opened != 0)
            {
                if (this.m_TcpClient != null && this.m_TcpClient.Connected == true)
                {
                    this.m_NetworkStream.Close();
                    this.m_TcpClient.Close();
                }
                this.m_NetworkStream = null;
                this.m_TcpClient = null;
            }
        }
        // Open/Close Button
        private void btnOpen_Close_Click(object sender, EventArgs e)
        {
            if(btnOpen_Close.Text == "OPEN"){
                try
                {
                    Opened = 1;
                    Cursor.Current = Cursors.WaitCursor;

                    // Device Open and Init
                    this.m_TcpClient = new System.Net.Sockets.TcpClient();
                    this.m_TcpClient.Connect(txtIPAddress.Text, 1026);
                    this.m_NetworkStream = this.m_TcpClient.GetStream();

                    btnLoad.Text = "OUT ON";
                    WriteLine("*cls\n");
                    WriteLine("ALLOUTOFF\n");           //Require 500ms Wait
                    System.Threading.Thread.Sleep(500);
                    WriteLine("*idn?\n");
                    System.Threading.Thread.Sleep(100);
                    txtMeasure.Text = Readbuff();

                    // Set form
                    btnOpen_Close.Text = "CLOSE";
                    btnLoad.Enabled = true;
                    btnMonitor.Enabled = true;
                    btnValueSet.Enabled = true;
                    btnVoltSet.Enabled = true;
                    txtIPAddress.Enabled = false;

                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.Message);
                    this.m_NetworkStream = null;
                    this.m_TcpClient = null;
                }
                finally
                {
                    Cursor.Current = Cursors.Default;
                }
            }
            else{
                try
                {
                    // Device Close
	                WriteLine("ALLOUTOFF\n");
	                WriteLine("LOCAL\n");

                    System.Threading.Thread.Sleep(200);
                    if (this.m_TcpClient != null && this.m_TcpClient.Connected == true)
                    {
                        this.m_NetworkStream.Close();
                        this.m_TcpClient.Close();
                    }
                    this.m_NetworkStream = null;
                    this.m_TcpClient = null;

                    // Set form
                    btnOpen_Close.Text = "OPEN";
                    btnLoad.Enabled = false ;
                    btnMonitor.Enabled = false ;
                    btnValueSet.Enabled = false ;
                    btnVoltSet.Enabled = false;
                    txtIPAddress.Enabled = true;
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.Message);
                }
            }

        }
        

        // Load Button
        private void btnLoad_Click(object sender, EventArgs e)
        {
            if (btnLoad.Text == "OUT ON")
            {
                // OFF -> ON
                WriteLine(":OUTP1 1\n");
                btnLoad.Text = "OUT OFF";
            }
            else
            {
                // ON -> OFF
                WriteLine(":OUTP1 0\n");
                btnLoad.Text = "OUT ON";
            }
        }

        // Set Button
        private void btnValueSet_Click(object sender, EventArgs e)
        {
            string SendMsg ;

            SendMsg = "ISET1:" + ReplaceCommonEscapeSequences(txtValue.Text + "\n");
            try
            {
                WriteLine(SendMsg);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
         }

        // Monitor Button
        private void btnMonitor_Click(object sender, EventArgs e)
        {
            string txtVoltage, txtCurrent, txtPower;
            try
            {
                Cursor.Current = Cursors.WaitCursor;

                WriteLine(":MEAS1:all?\n");
                System.Threading.Thread.Sleep(100);
                txtMeasure.Text = Readbuff() ;

            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
            finally
            {
                Cursor.Current = Cursors.Default;
            }
        }

        private string ReplaceCommonEscapeSequences(string s)
        {
            return s.Replace("\\n", "\n").Replace("\\r", "\r");
        }

        private string InsertCommonEscapeSequences(string s)
        {
            return s.Replace("\n", "\\n").Replace("\r", "\\r").Replace("\0", "\\0");
        }

        private void btnVoltSet_Click(object sender, EventArgs e)
        {
            string SendMsg;

            SendMsg = "VSET1:" + ReplaceCommonEscapeSequences(txtVoltage.Text + "\n"); 
            try
            {
                WriteLine(SendMsg);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }
        private void WriteLine(string sendMsg)
        {
            byte[] SendBuff = System.Text.Encoding.GetEncoding("SHIFT-JIS").GetBytes(sendMsg);
            m_NetworkStream.Write(SendBuff, 0, SendBuff.Length);
            m_NetworkStream.Flush();
        }
        private string Readbuff()
        {
            byte[] reciveBufff = new byte[256];

            int DataCnt = this.m_TcpClient.Available;
            if(DataCnt > 255) DataCnt = 255;
            m_NetworkStream.Read(reciveBufff,0,DataCnt);
            return System.Text.Encoding.GetEncoding("SHIFT-JIS").GetString(reciveBufff).Substring(0,DataCnt);
        }
    }
}
